/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2complements.content.enchantment.digging;

import dev.xkmc.l2complements.content.enchantment.core.CustomDescEnchantment;
import dev.xkmc.l2complements.content.enchantment.core.DiggerAndSwordEnchantment;
import dev.xkmc.l2complements.content.enchantment.core.UnobtainableEnchantment;
import dev.xkmc.l2complements.content.enchantment.digging.BlockBreaker;
import dev.xkmc.l2complements.content.enchantment.digging.DelayedBlockBreaker;
import dev.xkmc.l2complements.content.enchantment.digging.DiggerContext;
import dev.xkmc.l2complements.init.L2Complements;
import dev.xkmc.l2complements.init.data.LCConfig;
import dev.xkmc.l2complements.init.data.LangData;
import dev.xkmc.l2complements.init.data.TagGen;
import dev.xkmc.l2complements.init.registrate.LCEnchantments;
import dev.xkmc.l2library.init.events.GeneralEventHandler;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.registries.ForgeRegistries;

public class RangeDiggingEnchantment
extends UnobtainableEnchantment
implements CustomDescEnchantment {
    private static final Set<UUID> BREAKER = new HashSet<UUID>();
    private final BlockBreaker breaker;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execute(Player player, Runnable run) {
        Set<UUID> set = BREAKER;
        synchronized (set) {
            if (BREAKER.contains(player.m_20148_())) {
                return;
            }
            BREAKER.add(player.m_20148_());
            try {
                run.run();
            }
            catch (Exception e) {
                L2Complements.LOGGER.throwing(org.apache.logging.log4j.Level.ERROR, (Throwable)e);
            }
            BREAKER.remove(player.m_20148_());
        }
    }

    public static void breakBlockWrapped(ServerPlayer player, BlockPos pos) {
        player.f_8941_.m_9280_(pos);
    }

    public static boolean isSuppressed(UUID uuid) {
        return BREAKER.contains(uuid);
    }

    private static Direction getFace(Player player) {
        Level level = player.m_9236_();
        Vec3 base = player.m_20299_(0.0f);
        Vec3 look = player.m_20154_();
        double reach = player.m_21133_((Attribute)ForgeMod.BLOCK_REACH.get());
        Vec3 target = base.m_82520_(look.f_82479_ * reach, look.f_82480_ * reach, look.f_82481_ * reach);
        BlockHitResult trace = level.m_45547_(new ClipContext(base, target, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
        return trace.m_82434_();
    }

    private static double hardnessFactor() {
        return (Double)LCConfig.COMMON.chainDiggingHardnessRange.get();
    }

    private static boolean canBreak(BlockPos i, Level level, Player player, double hardness) {
        BlockState state = level.m_8055_(i);
        if (state.m_60795_()) {
            return false;
        }
        if (!player.m_36298_(state)) {
            return false;
        }
        float speed = state.m_60800_((BlockGetter)player.m_9236_(), i);
        if (speed < 0.0f) {
            return false;
        }
        return hardness < 0.0 || (double)speed <= hardness;
    }

    public RangeDiggingEnchantment(BlockBreaker breaker, Enchantment.Rarity pRarity, EnchantmentCategory pCategory, EquipmentSlot[] pApplicableSlots) {
        super(pRarity, pCategory, pApplicableSlots);
        this.breaker = breaker;
    }

    public int m_6586_() {
        return this.breaker.getMaxLevel();
    }

    public List<BlockPos> getTargets(Player player, BlockPos pos, ItemStack stack, int lv) {
        Level level = player.m_9236_();
        BlockState state = level.m_8055_(pos);
        double hardness = this.breaker.ignoreHardness() ? -1.0 : (double)state.m_60800_((BlockGetter)level, pos) * RangeDiggingEnchantment.hardnessFactor();
        return this.breaker.getInstance(new DiggerContext(player, RangeDiggingEnchantment.getFace(player), stack, lv, pos, state)).find(level, pos, i -> !pos.equals(i) && RangeDiggingEnchantment.canBreak(i, level, player, hardness));
    }

    public void onBlockBreak(ServerPlayer player, BlockPos pos, ItemStack stack, int lv) {
        List<BlockPos> blocks = this.getTargets((Player)player, pos, stack, lv);
        RangeDiggingEnchantment.execute((Player)player, () -> {
            int max = (Integer)LCConfig.COMMON.chainDiggingDelayThreshold.get();
            if (blocks.size() <= max) {
                for (BlockPos i : blocks) {
                    RangeDiggingEnchantment.breakBlockWrapped(player, i);
                }
            } else {
                if (((Boolean)LCConfig.COMMON.delayDiggingRequireEnder.get()).booleanValue() && stack.getEnchantmentLevel((Enchantment)LCEnchantments.ENDER.get()) <= 0) {
                    player.m_240418_((Component)LangData.IDS.DELAY_WARNING.get(((DiggerAndSwordEnchantment)LCEnchantments.ENDER.get()).m_44700_(1), max).m_130940_(ChatFormatting.RED), true);
                    return;
                }
                GeneralEventHandler.schedulePersistent(new DelayedBlockBreaker(player, blocks)::tick);
            }
        });
    }

    @Override
    public List<Component> descFull(int lv, String key, boolean alt, boolean book) {
        return this.breaker.descFull(lv, key, alt, book);
    }

    protected boolean m_5975_(Enchantment e) {
        return !ForgeRegistries.ENCHANTMENTS.tags().getTag(TagGen.DIGGER_ENCH).contains((Object)e);
    }

    @Override
    public int getDecoColor(String s) {
        return -5263441;
    }
}

